import crypto from "crypto";

/**
 * Generate a secure random token for password reset
 */
export function generatePasswordResetToken(): string {
  return crypto.randomBytes(32).toString("hex");
}

/**
 * Calculate expiration date for password reset token
 * @param hours - Number of hours until expiration (default: 48 for welcome emails, 1 for reset requests)
 */
export function getPasswordResetExpiration(hours: number = 48): Date {
  const expiration = new Date();
  expiration.setHours(expiration.getHours() + hours);
  return expiration;
}

